
#################### Ozabaci, Henderson, and Su's (2014) procedure ####################

########## 1st stage ##########

Dat.1=Dat[-c(1)]
iv=Dat.1[c(2)]

iv=as.matrix(iv)
n=nrow(Dat)
knots=floor(2*n^(1/5)+3)
iv.s=bs(iv,df=knots)

dat.11=Dat.1[-c(2)]
dat.1=cbind(iv.s,dat.11)

ols=lm(wheat_aid~.,data=dat.1)
res=residuals(ols)
res=as.matrix(res)

########## 2nd stage ##########

Dat.2=Dat[-c(3)]
en=Dat.2[c(2)]

en=as.matrix(en)
en.s=bs(en,df=knots)

dat.22=Dat.2[-c(2)]
dat.2=cbind(res,en.s,dat.22)
ols=lm(intra_state~.,data=dat.2)
fit=fitted.values(ols)
fit=as.matrix(fit)

nn=ncol(en.s)
coef=coefficients(ols)[3:(3+nn-1)]
coef[is.na(coef)]=0
coef=as.matrix(coef)

x=dat.2[c(2:(2+nn-1))]
x=as.matrix(x)

fit.x=x%*%coef

y=dat.2$intra_state
y=as.matrix(y)

y.s=y-fit+fit.x

########## 3th stage (nonparametric estimation) ##########

boot=399
num=round(max(en)*0.1) # an integer specifying the number of evaluation points #

y.s=as.numeric(y.s)
en=as.numeric(en)

bwll.sp=npregbw(y.s~en,regtype="ll",residuals=TRUE,gradients=TRUE,bwmethod="cv.ls")
#bwll.sp=npregbw(y.s~en,regtype="ll",residuals=TRUE,gradients=TRUE,bwmethod="cv.aic")#
# only for two cases: 5 year window and low ethnic polarization #
llls.sp=npreg(bws=bwll.sp,regtype="ll",residuals=TRUE,gradients=TRUE)

plot.out=plot(bws=bwll.sp,plot.errors.method="bootstrap",plot.errors.boot.num=boot,neval=num,plot.behavior=c("data"))
sp.fit=fitted(plot.out$r1)
sp.fit.se=se(plot.out$r1)
sp.fit.lower=sp.fit+1.96*sp.fit.se[,1]
sp.fit.upper=sp.fit+1.96*sp.fit.se[,2]

plot.out=plot(bws=bwll.sp,gradients=TRUE,plot.errors.method="bootstrap",plot.errors.boot.num=boot,neval=num,plot.behavior=c("data"))
grad=gradients(plot.out$rg1)
grad.se=gradients(plot.out$rg1,errors=TRUE)
grad.lower=grad+1.96*grad.se[,1]
grad.upper=grad+1.96*grad.se[,2]

########## 3th stage (parametric estimation) ##########

h=10000
bwll.p=npregbw(y.s~en,regtype="ll",residuals=TRUE,gradients=TRUE,bandwidth.compute=FALSE,bws=h)
llls.p=npreg(bws=bwll.p,regtype="ll",residuals=TRUE,gradients=TRUE)

plot.out=plot(bws=bwll.p,plot.errors.method="bootstrap",plot.errors.boot.num=boot,neval=num,plot.behavior=c("data"))
p.fit=fitted(plot.out$r1)
p.fit.se=se(plot.out$r1)
p.fit.lower=p.fit+1.96*p.fit.se[,1]
p.fit.upper=p.fit+1.96*p.fit.se[,2]

plot.out=plot(bws=bwll.p,gradients=TRUE,plot.errors.method="bootstrap",plot.errors.boot.num=boot,neval=num,plot.behavior=c("data"))
beta=gradients(plot.out$rg1)
beta.se=gradients(plot.out$rg1,errors=TRUE)
beta.lower=beta+1.96*beta.se[,1]
beta.upper=beta+1.96*beta.se[,2]

# split the full sample to two types of countries #

z=cbind(en,I)
z.1=subset(z,I==1)
z.2=subset(z,I==0)
z.1.max=round(max(z.1)*0.1)
z.2.max=round(max(z.2)*0.1)

grad.1=grad[1:z.1.max]
grad.lower.1=grad.lower[1:z.1.max]
grad.upper.1=grad.upper[1:z.1.max]

grad.2=grad[1:z.2.max]
grad.lower.2=grad.lower[1:z.2.max]
grad.upper.2=grad.upper[1:z.2.max]

beta.1=beta[1:z.1.max]
beta.lower.1=beta.lower[1:z.1.max]
beta.upper.1=beta.upper[1:z.1.max]

beta.2=beta[1:z.2.max]
beta.lower.2=beta.lower[1:z.2.max]
beta.upper.2=beta.upper[1:z.2.max]

zero=matrix(0,nrow=num,ncol=1)

########## plots ##########

# use the below as main="" in plot() for marginal effects #

# 1_table11_2 # 20-Year Window   No 20-Year Window #
# 2_table11_3 # 15-Year Window   No 15-Year Window #
# 3_table11_4 # 10-Year Window   No 10-Year Window #
# 4_table11_5 # 5-Year Window   No 5-Year Window #
# 5_table12_2 # High Income   Low Income #
# 6_table12_3 # High Resource Dependence   Low Resource Dependecne #
# 7_table12_4 # High Polity   Low Polity #
# 8_table12_5 # Low Ethnic Polarization   High Ethnic Polarization #
# 9_table12_6 # Low Ethnic Diversity   High Ethnic Diversity #
# 10_table13_2 # Low Cereal Producer   High Cereal Producer #
# 11_table13_3 # Low Cereal Production Years   High Cereal Production Years #
# 12_table13_4 # High Road Density   Low Road Density #
# 13_table13_5 # Cold War Years   Post Cold War Years #
# 14_table13_6 # Aligned with the US   Non-Aligned with the US #

##### fitted values #####

labels.x=c(0,0.5,1.0,1.5,2.0)

par(mfrow=c(1,3))

par(cex.lab=2.5,cex.axis=2.25,cex.main=3,mar=c(5,5,4,1)+0.1)
plot(sp.fit,type="l",lty=2,xlab="US Wheat Aid",ylab="Fitted  Value",main="Full Sample",ylim=c(-2,2),col="red",lwd=4,xaxt="n")
axis(side=1,at=seq(0,200,by=50),labels=labels.x)
lines(sp.fit.lower,lty=1,xlab="",ylab="",main="",ylim=c(-2,2),col="black",lwd=3)
lines(sp.fit.upper,lty=1,xlab="",ylab="",main="",ylim=c(-2,2),col="black",lwd=3)
lines(zero,lty=1,xlab="",ylab="",main="",ylim=c(-2,2),col="gray",lwd=3)
lines(p.fit,lty=3,xlab="",ylab="",main="",ylim=c(-2,2),col="blue",lwd=5)
lines(p.fit.lower,lty=1,xlab="",ylab="",main="",ylim=c(-2,2),col="black",lwd=3)
lines(p.fit.upper,lty=1,xlab="",ylab="",main="",ylim=c(-2,2),col="black",lwd=3)
legend("topleft",c("Semiparametric Fitted Value","Parametric Fitted Value","Bootstrapped 95% CI"),col=c("red","blue","black"),lty=c(2,3,1),lwd=c(2.5,3,3),bty="n",cex=2.5)

########## marginal effects ##########

par(cex.lab=2.5,cex.axis=2.25,cex.main=3,mar=c(5,5,4,1)+0.1)
plot(zero,type="l",lty=1,xlab="US Wheat Aid",ylab="Marginal  Effect",main="High Income",ylim=c(-0.006,0.006),col="gray",lwd=3,xaxt="n")
axis(side=1,at=seq(0,200,by=50),labels=labels.x) # change main="" #
lines(grad.1,lty=2,xlab="",ylab="",main="",ylim=c(-0.006,0.006),col="red",lwd=4)
lines(grad.lower.1,lty=1,xlab="",ylab="",main="",ylim=c(-0.006,0.006),col="black",lwd=3)
lines(grad.upper.1,lty=1,xlab="",ylab="",main="",ylim=c(-0.006,0.006),col="black",lwd=3)
lines(beta.1,lty=3,xlab="",ylab="",main="",ylim=c(-0.006,0.006),col="blue",lwd=5)
lines(beta.lower.1,lty=1,xlab="",ylab="",main="",ylim=c(-0.006,0.006),col="black",lwd=3)
lines(beta.upper.1,lty=1,xlab="",ylab="",main="",ylim=c(-0.006,0.006),col="black",lwd=3)
legend("topleft",c("Gradient","Coefficient","Bootstrapped 95% CI"),col=c("red","blue","black"),lty=c(2,3,1),lwd=c(2.5,3,3),bty="n",cex=2.5)

par(cex.lab=2.5,cex.axis=2.25,cex.main=3,mar=c(5,5,4,1)+0.1)
plot(zero,type="l",lty=1,xlab="US Wheat Aid",ylab="Marginal  Effect",main="Low Income",ylim=c(-0.006,0.006),col="gray",lwd=3,xaxt="n")
axis(side=1,at=seq(0,200,by=50),labels=labels.x) # change main="" #
lines(grad.2,lty=2,xlab="",ylab="",main="",ylim=c(-0.006,0.006),col="red",lwd=4)
lines(grad.lower.2,lty=1,xlab="",ylab="",main="",ylim=c(-0.006,0.006),col="black",lwd=3)
lines(grad.upper.2,lty=1,xlab="",ylab="",main="",ylim=c(-0.006,0.006),col="black",lwd=3)
lines(beta.2,lty=3,xlab="",ylab="",main="",ylim=c(-0.006,0.006),col="blue",lwd=5)
lines(beta.lower.2,lty=1,xlab="",ylab="",main="",ylim=c(-0.006,0.006),col="black",lwd=3)
lines(beta.upper.2,lty=1,xlab="",ylab="",main="",ylim=c(-0.006,0.006),col="black",lwd=3)
legend("topleft",c("Gradient","Coefficient","Bootstrapped 95% CI"),col=c("red","blue","black"),lty=c(2,3,1),lwd=c(2.5,3,3),bty="n",cex=2.5)
